
#!/bin/sh

version=04
vanillamd5="0e63d4223b01d9aba596259dc155a174"
modmd5="6bb8c6132da7c22011dc99297ded46fa"

infile="$1"
outfile="20XX 4.0 Beta${version}.iso"
delta="20XX 4.0 Beta${version} xdelta patch.xdelta"

# not doing checking, so make sure you have these binaries installed somewhere
xdelta=xdelta3
md5sum=md5sum


checkhash () {
	printf "    This will take a few moments...."
	filehash=$(${md5sum} -b "$1" |cut -d' ' -f1)
	if [ "$filehash" != "$2" ]; then
		printf "FAIL\n"
		printf "Hashes don't match. Continue? (y/n) "
		read cont;
		if [ "$cont" != "y" ]; then
			exit
		fi
	fi
	printf "SUCCESS\n"
}

build () {
	if [ -f "$outfile" ]; then
		printf "File $outfile already exists. Overwrite? (y/n) "
		read overwrite
		if [ "$overwrite" != "y" ]; then
			exit
		fi
	fi
	printf "Constructing 20XX 4.0 Beta${version}.\n"
	printf "    Please stand by...."

	$xdelta -f -d -s "$infile" "$delta" "$outfile" 2>/dev/null && printf "SUCCESS\n" || printf "FAIL\n"
}

if [ "$infile" = "" ]; then
	printf "usage: 20XX-4.0.${version}-convert.sh FILE\n"
	exit
fi
printf "Verifying that the given file is a vanilla v1.02 copy of SSBM.\n"
checkhash "$infile" "$vanillamd5"
printf "The ISO has been verified!\n\n"

build
test $? -eq 0 || exit
printf "Conversion complete!\n\n"

printf "Would you like to check the hash of your new 20XX copy? (y/n): "
read check;
if [ "$check" = "y" ]; then
	checkhash "$outfile" "$modmd5"
fi